<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function myBranch()
    {
        return $this->belongsTo('App\Models\Branch', 'branch_id');
    }

    public function myPayorRelationship()
    {
        return $this->belongsTo('App\Models\PayorsRelation', 'payor_relation_id');
    }

    public function myProvince()
    {
        return $this->belongsTo('App\Models\Province', 'province_id');
    }

    public function myIdentificationType()
    {
        return $this->belongsTo('App\Models\IdentificationType', 'identification_type_id');
    }

    public function myAgent()
    {
        return $this->belongsTo('App\Models\Agent', 'agents_id');
    }

}